/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import twilightforest.TFSounds;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.block.entity.TrophyBlockEntity;
import twilightforest.client.particle.TFParticleType;
import twilightforest.enums.BossVariant;
import twilightforest.item.TFItems;

public abstract class AbstractTrophyBlock
extends class_2237 {
    private final BossVariant variant;
    private final int comparatorValue;
    public static final class_2746 POWERED = class_2741.field_12484;

    protected AbstractTrophyBlock(BossVariant variant, int value, class_4970.class_2251 builder) {
        super(builder);
        this.variant = variant;
        this.comparatorValue = value;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public int getComparatorValue() {
        return this.comparatorValue;
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_9236 && (flag = worldIn.method_8479(pos)) != (Boolean)state.method_11654((class_2769)POWERED)) {
            if (flag) {
                this.playSound(worldIn, pos);
            }
            worldIn.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 handIn, class_3965 hit) {
        this.playSound(worldIn, pos);
        this.createParticle(worldIn, pos);
        return class_1269.field_5812;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TrophyBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return AbstractTrophyBlock.method_31618(type, (class_2591)((class_2591)TFBlockEntities.TROPHY.get()), TrophyBlockEntity::tick);
    }

    public BossVariant getVariant() {
        return this.variant;
    }

    public boolean method_9516(class_2680 state, class_1922 worldIn, class_2338 pos, class_10 type) {
        return false;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED});
    }

    public void playSound(class_1937 world, class_2338 pos) {
        class_2586 te = world.method_8321(pos);
        if (!world.field_9236 && te instanceof TrophyBlockEntity) {
            class_3414 sound = null;
            float volume = 1.0f;
            float pitch = 0.9f;
            switch (this.variant) {
                case NAGA: {
                    sound = TFSounds.NAGA_RATTLE;
                    volume = 1.25f;
                    pitch = 1.2f;
                    break;
                }
                case LICH: {
                    sound = TFSounds.LICH_AMBIENT;
                    volume = 0.35f;
                    pitch = 1.1f;
                    break;
                }
                case HYDRA: {
                    sound = TFSounds.HYDRA_GROWL;
                    pitch = 1.2f;
                    break;
                }
                case UR_GHAST: {
                    sound = TFSounds.URGHAST_AMBIENT;
                    pitch = 0.6f;
                    break;
                }
                case SNOW_QUEEN: {
                    sound = TFSounds.SNOW_QUEEN_AMBIENT;
                    break;
                }
                case KNIGHT_PHANTOM: {
                    sound = TFSounds.PHANTOM_AMBIENT;
                    pitch = 1.1f;
                    break;
                }
                case MINOSHROOM: {
                    sound = TFSounds.MINOSHROOM_AMBIENT;
                    volume = 0.75f;
                    pitch = 0.7f;
                    break;
                }
                case ALPHA_YETI: {
                    sound = world.field_9229.nextInt(50) == 0 ? TFSounds.ALPHAYETI_ROAR : TFSounds.ALPHAYETI_GROWL;
                    volume = 0.75f;
                    pitch = 0.75f;
                    break;
                }
                case QUEST_RAM: {
                    sound = TFSounds.QUEST_RAM_AMBIENT;
                    pitch = 0.7f;
                    break;
                }
            }
            if (sound != null) {
                world.method_8396(null, pos, sound, class_3419.field_15245, volume, world.field_9229.nextFloat() * 0.1f + pitch);
            }
        }
    }

    public void createParticle(class_1937 world, class_2338 pos) {
        class_2586 te = world.method_8321(pos);
        if (te instanceof TrophyBlockEntity) {
            Random rand = world.method_8409();
            if (world instanceof class_3218) {
                switch (this.variant) {
                    case NAGA: {
                        for (int daze = 0; daze < 10; ++daze) {
                            ((class_3218)world).method_14199((class_2394)class_2398.field_11205, (double)pos.method_10263() + (double)rand.nextFloat() * 0.5 * 2.0, (double)pos.method_10264() + 0.25, (double)pos.method_10260() + (double)rand.nextFloat() * 0.5 * 2.0, 1, 0.0, 0.0, 0.0, rand.nextGaussian() * 0.02);
                        }
                        break;
                    }
                    case LICH: {
                        for (int a = 0; a < 5; ++a) {
                            ((class_3218)world).method_14199((class_2394)class_2398.field_11231, (double)pos.method_10263() + (double)rand.nextFloat() * 0.5 * 2.0, (double)pos.method_10264() + 0.5 + (double)rand.nextFloat() * 0.25, (double)pos.method_10260() + (double)rand.nextFloat() * 0.5 * 2.0, 1, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02, 0.0);
                        }
                        break;
                    }
                    case MINOSHROOM: {
                        for (int g = 0; g < 10; ++g) {
                            ((class_3218)world).method_14199((class_2394)new class_2388(class_2398.field_11217, world.method_8320(pos.method_10074())), (double)pos.method_10263() + (double)(rand.nextFloat() * 10.0f) - 5.0, (double)pos.method_10264() + (double)0.1f + (double)(rand.nextFloat() * 0.3f), (double)pos.method_10260() + (double)(rand.nextFloat() * 10.0f) - 5.0, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case KNIGHT_PHANTOM: {
                        for (int brek = 0; brek < 10; ++brek) {
                            ((class_3218)world).method_14199((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)TFItems.KNIGHTMETAL_SWORD.get())), (double)pos.method_10263() + 0.5 + ((double)rand.nextFloat() - 0.5), (double)((float)pos.method_10264() + rand.nextFloat()) + 0.5, (double)pos.method_10260() + 0.5 + ((double)rand.nextFloat() - 0.5), 1, 0.0, 0.25, 0.0, 0.0);
                        }
                        break;
                    }
                    case UR_GHAST: {
                        for (int red = 0; red < 10; ++red) {
                            ((class_3218)world).method_14199((class_2394)class_2390.field_11188, (double)pos.method_10263() + rand.nextDouble() * 1.0 - 0.25, (double)pos.method_10264() + rand.nextDouble() * 0.5 + 0.5, (double)pos.method_10260() + rand.nextDouble() * 1.0, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case ALPHA_YETI: {
                        for (int sweat = 0; sweat < 10; ++sweat) {
                            ((class_3218)world).method_14199((class_2394)class_2398.field_11202, (double)pos.method_10263() + rand.nextDouble() * 1.0 - 0.25, (double)pos.method_10264() + rand.nextDouble() * 0.5 + 0.5, (double)pos.method_10260() + rand.nextDouble() * 1.0, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case SNOW_QUEEN: {
                        for (int b = 0; b < 20; ++b) {
                            ((class_3218)world).method_14199((class_2394)((class_2400)TFParticleType.SNOW_WARNING.get()), (double)pos.method_10263() - 1.0 + rand.nextDouble() * 3.25, (double)pos.method_10264() + 5.0, (double)pos.method_10260() - 1.0 + rand.nextDouble() * 3.25, 1, 0.0, 1.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case QUEST_RAM: {
                        for (int p = 0; p < 10; ++p) {
                            ((class_3218)world).method_14199((class_2394)class_2398.field_11226, (double)pos.method_10263() + 0.5 + (rand.nextDouble() - 0.5), (double)pos.method_10264() + (rand.nextDouble() - 0.5), (double)pos.method_10260() + 0.5 + (rand.nextDouble() - 0.5), 1, (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat(), 1.0);
                        }
                        break;
                    }
                }
            }
        }
    }
}

